<?php
 
function artabr_register_post_types () {	
	register_post_type ( 'gallery' , 
			array(
				'labels' => array ( 
					'name' => __('Gallery','hbthemes'),
					'all_items' => __( 'All Gallery Items' , 'hbthemes' ),
					'singular_name' => __( 'Gallery Item' , 'hbthemes' ) ,		
					'add_new' => __( 'Add New Gallery Item', 'hbthemes' ),
					'add_new_item' => __( 'Add New Gallery Item', 'hbthemes' ),
					'edit_item' => __( 'Edit Gallery Item', 'hbthemes' ),
					'new_item' =>  __( 'New Gallery Item', 'hbthemes' ),
					'view_item' =>  __( 'View Gallery Item', 'hbthemes' ),
					'search_items' =>  __( 'Search For Gallery Items', 'hbthemes' ),
					'not_found' =>  __( 'No Gallery Items found', 'hbthemes' ),
					'not_found_in_trash' => __( 'No Gallery Items found in Trash', 'hbthemes' ),
					'parent_item_colon' => ''
				),
				'public' => true,
				'show_ui' => true,
				'_builtin' => false,
				'_edit_link' => 'post.php?post=%d',
				'capability_type' => 'post',
				'hierarchical' => false,
				'menu_position' => 100,
				'supports' => array(
						'title', 
						'editor', 
						'thumbnail',
						'page-attributes',
						'custom-fields',
						),
				'query_var' => true,
				'exclude_from_search' => false,
				'show_in_nav_menus' => true,
				'menu_icon' => 'dashicons-format-gallery',
			)
		);
	$gallery_category_labels = array(
		'name' => __( 'Gallery Categories', 'hbthemes' ),
		'singular_name' => __( 'Gallery Category', 'hbthemes' ),
		'search_items' =>  __( 'Search Gallery Categories', 'hbthemes' ),
		'all_items' => __( 'All Gallery Categories', 'hbthemes' ),
		'parent_item' => __( 'Parent Gallery Category', 'hbthemes' ),
		'parent_item_colon' => __( 'Parent Gallery Category:', 'hbthemes' ),
		'edit_item' => __( 'Edit Gallery Category', 'hbthemes' ),
		'update_item' => __( 'Update Gallery Category', 'hbthemes' ),
		'add_new_item' => __( 'Add New Gallery Category', 'hbthemes' ),
		'new_item_name' => __( 'New Gallery Category Name', 'hbthemes' ),
		'choose_from_most_used'	=> __( 'Choose from the most used Gallery categories', 'hbthemes' )
	); 	

	register_taxonomy('gallery_categories', 'gallery' ,array(
		'hierarchical' => true,
		'labels' => $gallery_category_labels,
		'query_var' => true,
		'rewrite' => array( 'slug' => __('gallery_category','hbthemes') ),
	));

}
add_action( 'init', 'artabr_register_post_types', 20 );

